% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTableIntersect.R
\name{addTableIntersect}
\alias{addTableIntersect}
\title{Compute the intersect with an omop table, you can compute the number of
occurrences, a flag of presence, a certain date, the time difference and/or
obtain a certain column.}
\usage{
addTableIntersect(
  x,
  tableName,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  window = list(c(0, Inf)),
  order = "first",
  targetStartDate = startDateColumn(tableName),
  targetEndDate = endDateColumn(tableName),
  flag = TRUE,
  count = TRUE,
  date = TRUE,
  days = TRUE,
  field = character(),
  nameStyle = "{table_name}_{value}_{window_name}"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{tableName}{Name of the table to intersect with. Options:
visit_occurrence, condition_occurrence, drug_exposure, procedure_occurrence,
device_exposure, measurement, observation, drug_era, condition_era, specimen.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a specific date
or a column date of x.}

\item{window}{window to consider events in.}

\item{order}{which record is considered in case of multiple records (only
required for date and days options).}

\item{targetStartDate}{Column name with start date for comparison.}

\item{targetEndDate}{Column name with end date for comparison.}

\item{flag}{TRUE or FALSE. If TRUE, flag will calculated for this
intersection.}

\item{count}{TRUE or FALSE. If TRUE, the number of counts will be calculated
for this intersection.}

\item{date}{TRUE or FALSE. If TRUE, date will be calculated for this
intersection.}

\item{days}{TRUE or FALSE. If TRUE, time difference in days will be
calculated for this intersection.}

\item{field}{Other columns from the table to intersect.}

\item{nameStyle}{naming of the added column or columns, should include
required parameters.}
}
\value{
table with added columns with intersect information.
}
\description{
Compute the intersect with an omop table, you can compute the number of
occurrences, a flag of presence, a certain date, the time difference and/or
obtain a certain column.
}
\examples{
\donttest{
cdm <- mockPatientProfiles()

cdm$cohort1 \%>\%
  addTableIntersect(tableName = "visit_occurrence")
CDMConnector::cdmDisconnect(cdm = cdm)
}

}
