% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ViewShinyPlp.R
\name{viewDatabaseResultPlp}
\alias{viewDatabaseResultPlp}
\title{open a local shiny app for viewing the result of a PLP analyses from a database}
\usage{
viewDatabaseResultPlp(
  mySchema,
  myServer,
  myUser,
  myPassword,
  myDbms,
  myPort = NULL,
  myTableAppend
)
}
\arguments{
\item{mySchema}{Database result schema containing the result tables}

\item{myServer}{server with the result database}

\item{myUser}{Username for the connection to the result database}

\item{myPassword}{Password for the connection to the result database}

\item{myDbms}{database management system for the result database}

\item{myPort}{Port for the connection to the result database}

\item{myTableAppend}{A string appended to the results tables (optional)}
}
\value{
Opens a shiny app for interactively viewing the results
}
\description{
open a local shiny app for viewing the result of a PLP analyses from a database
}
\details{
Opens a shiny app for viewing the results of the models from a database
}
\examples{
\dontshow{if (rlang::is_interactive() && rlang::is_installed("Eunomia") && rlang::is_installed("OhdsiShinyAppBuilder") && rlang::is_installed("curl") && curl::has_internet()  ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{  \dontshow{ # takes too long }
connectionDetails <- Eunomia::getEunomiaConnectionDetails()
Eunomia::createCohorts(connectionDetails)
databaseDetails <- createDatabaseDetails(connectionDetails = connectionDetails,
                                          cdmDatabaseSchema = "main",
                                          cdmDatabaseName = "Eunomia",
                                          cdmDatabaseId = "1",
                                          targetId = 1,
                                          outcomeIds = 3)
modelDesign <- createModelDesign(targetId = 1,
                                 outcomeId = 3,
                                 modelSettings = setLassoLogisticRegression())
saveLoc <- file.path(tempdir(), "viewDatabaseResultPlp", "developement")
runMultiplePlp(databaseDetails = databaseDetails, modelDesignList = list(modelDesign),
               saveDirectory = saveLoc)
# view result files
dir(saveLoc, recursive = TRUE)
viewDatabaseResultPlp(myDbms = "sqlite", 
                      mySchema = "main", 
                      myServer = file.path(saveLoc, "sqlite", "databaseFile.sqlite"),
                      myUser = NULL,
                      myPassword = NULL,
                      myTableAppend = "")
# clean up, shiny app can't be opened after the following has been run
unlink(saveLoc, recursive = TRUE)
}
\dontshow{\}) # examplesIf}
}
