% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CollectiveModelMethods.R
\name{Layer_Mean}
\alias{Layer_Mean}
\title{Expected Loss of a Reinsurance Layer}
\usage{
Layer_Mean(CollectiveModel, Cover = Inf, AttachmentPoint = 0)
}
\arguments{
\item{CollectiveModel}{A collective model object. Currently only \code{PPP_Models} are handled.}

\item{Cover}{Numeric. Cover of the reinsurance layer. Use \code{Inf} for unlimited layers.}

\item{AttachmentPoint}{Numeric. Attachment point of the reinsurance layer.}
}
\value{
The expected loss of the layer \code{Cover} xs \code{AttachmentPoint} for the given \code{CollectiveModel}
}
\description{
Calculates the expected loss of a reinsurance layer for a collective model
}
\examples{
PPPM <- PiecewisePareto_Match_Layer_Losses(Example1_AP, Example1_EL)
PPPM
Example1_Cov <- c(diff(Example1_AP), Inf)
Example1_AP
Example1_Cov
Example1_EL
Layer_Mean(PPPM, Example1_Cov, Example1_AP)

}
