% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{Pareto_ML_Estimator_Alpha}
\alias{Pareto_ML_Estimator_Alpha}
\title{Maximum Likelihood Estimation of the Pareto Alpha}
\usage{
Pareto_ML_Estimator_Alpha(
  losses,
  t,
  truncation = NULL,
  weights = NULL,
  tol = 1e-07,
  max_iterations = 1000,
  alpha_min = 0,
  alpha_max = Inf
)
}
\arguments{
\item{losses}{Numeric vector. Losses that are used for the ML estimation.}

\item{t}{Numeric or numeric vector. Threshold of the Pareto distribution. Alternatively, \code{t} can be a vector of same length as \code{losses}. In this case \code{t[i]} is the reporting threshold of \code{losses[i]}.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the Pareto distribution is truncated at \code{truncation}.}

\item{weights}{Numeric vector. Weights for the losses. For instance \code{weights[i] = 2} and \code{weights[j] = 1} for \code{j != i} has the same effect as adding another loss of size \code{loss[i]}.}

\item{tol}{Numeric. Desired accuracy  (only relevant in the truncated case).}

\item{max_iterations}{Numeric. Maximum number of iteration in the case \code{truncation < Inf}  (only relevant in the truncated case).}

\item{alpha_min}{Numeric. Deprecated.}

\item{alpha_max}{Numeric. Deprecated.}
}
\value{
Maximum likelihood estimator for the parameter \code{alpha} of a Pareto distribution with threshold \code{t} given the observations \code{losses}
}
\description{
Calculates the maximum likelihood estimator of the parameter alpha of a Pareto distribution
}
\examples{
losses <- rPareto(100, 1000, 2)
Pareto_ML_Estimator_Alpha(losses, 1000)
losses <- rPareto(100, 1000, 2, truncation = 2000)
Pareto_ML_Estimator_Alpha(losses, 1000)
Pareto_ML_Estimator_Alpha(losses, 1000, truncation = 2000)

t <- rPareto(10000, 100, 2)
alpha <- 2
losses <- rPareto(10000, t, alpha)
Pareto_ML_Estimator_Alpha(losses, t)
losses <- rPareto(10000, t, alpha, truncation = 2 * max(t))
Pareto_ML_Estimator_Alpha(losses, t, truncation = 2 * max(t))

losses <- rPareto(10, 1000, 2)
w <- rep(1, 10)
w[1] <- 3
losses2 <- c(losses, losses[1], losses[1])
Pareto_ML_Estimator_Alpha(losses, 1000, weights = w)
Pareto_ML_Estimator_Alpha(losses2, 1000)
}
