% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CollectiveModelMethods.R
\name{Layer_Var}
\alias{Layer_Var}
\title{Variance of a Reinsurance Layer}
\usage{
Layer_Var(CollectiveModel, Cover = Inf, AttachmentPoint = 0)
}
\arguments{
\item{CollectiveModel}{A collective model object. Currently only \code{PPP_Models} are handled.}

\item{Cover}{Numeric. Cover of the reinsurance layer. Use \code{Inf} for unlimited layers.}

\item{AttachmentPoint}{Numeric. Attachment point of the reinsurance layer.}
}
\value{
The variance of the loss in the layer \code{Cover} xs \code{AttachmentPoint} for the given \code{CollectiveModel}
}
\description{
Calculates the variance of the loss in a reinsurance layer for a collective model
}
\examples{
PPPM <- PiecewisePareto_Match_Layer_Losses(Example1_AP, Example1_EL)
PPPM
Example1_Cov <- c(diff(Example1_AP), Inf)
Layer_Var(PPPM, Example1_Cov, Example1_AP)

}
