% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesianOptimization.R
\name{BayesianOptimization}
\alias{BayesianOptimization}
\title{Bayesian Optimization with Gaussian Processes}
\usage{
BayesianOptimization(
  FUN,
  bounds,
  saveIntermediate = NULL,
  leftOff = NULL,
  parallel = FALSE,
  packages = NULL,
  export = NULL,
  initialize = TRUE,
  initGrid = NULL,
  initPoints = 0,
  bulkNew = 1,
  nIters = 0,
  kern = "Matern52",
  beta,
  acq = "ucb",
  stopImpatient = list(newAcq = "ucb", rounds = Inf),
  kappa = 2.576,
  eps = 0,
  gsPoints = 100,
  convThresh = 1e+07,
  minClusterUtility = NULL,
  noiseAdd = 0.25,
  plotProgress = TRUE,
  verbose = 1
)
}
\arguments{
\item{FUN}{the function to be maximized. This function should return a
named list with at least 1 component. The first component must be named
\code{Score} and should contain the metric to be maximized. You may
return other named scalar elements that you wish to include in the final
summary table.}

\item{bounds}{named list of lower and upper bounds for each hyperparameter.
The names of the list should be arguments passed to \code{FUN}.
Use "L" suffix to indicate integer hyperparameters.}

\item{saveIntermediate}{character filepath (including file name) that
specifies the location to save intermediary results. This will save
the ScoreDT data.table as an RDS. This RDS is saved after every
iteration, and can be specified as the \code{leftOff} parameter
so that you can continue a process where you left off.}

\item{leftOff}{data.table containing parameter-Score pairs. If supplied,
the process will \code{rbind} this table to the parameter-Score pairs
obtained through initialization. This table should be obtained
from either the file saved by \code{saveIntermediate}, or from the ScoreDT
\code{data.table} returned by this function. WARNING: any parameters
not within \code{bounds} will be removed before optimization takes place.}

\item{parallel}{should the process run in parallel? If TRUE, several criteria must be met:
\itemize{
  \item A parallel backend must be registered
  \item \code{FUN} must be executable using only packages specified in \code{packages} (and base packages)
  \item \code{FUN} must be executable using only the the objects specified in \code{export}
  \item The function must be thread safe.
}}

\item{packages}{character vector of the packages needed to run \code{FUN}.}

\item{export}{character vector of object names needed to evaluate \code{FUN}.}

\item{initialize}{should the process initialize a parameter-Score pair set?
If \code{FALSE}, \code{leftOff} must be provided.}

\item{initGrid}{user specified points to sample the scoring function, should
be a \code{data.frame} or \code{data.table} with identical column names as bounds.}

\item{initPoints}{Number of points to initialize the process with. Points are
chosen with latin hypercube sampling within the bounds supplied.}

\item{bulkNew}{integer that specifies the number of parameter combinations
to sample at each optimization step. If \code{minClusterUtility} is \code{NULL}
then noise is added to the acquisition optimum to obtain other sampling points.
If running in parallel, good practice is to set \code{bulkNew} to some multiple
of the number of cores you have designated for this process.}

\item{nIters}{total number of parameter sets to be sampled, including initial set.}

\item{kern}{a character that gets mapped to one of GauPro's \code{GauPro_kernel_beta}
  S6 classes. Determines the covariance function used in the gaussian process. Can be one of:
\itemize{
  \item \code{"Gaussian"}
  \item \code{"Exponential"}
  \item \code{"Matern52"}
  \item \code{"Matern32"}
}}

\item{beta}{Depreciated. The kernel lengthscale parameter log10(theta). Passed to \code{GauPro_kernel_beta} specified in kern.}

\item{acq}{acquisition function type to be used. Can be "ucb", "ei", "eips" or "poi".
\itemize{
  \item \code{ucb}   Upper Confidence Bound
  \item \code{ei}    Expected Improvement
  \item \code{eips}  Expected Improvement Per Second
  \item \code{poi}   Probability of Improvement
}}

\item{stopImpatient}{a list containing \code{rounds} and \code{newAcq},
if \code{acq = "eips"} you can switch the acquisition function to \code{newAcq}
after \code{rounds} parameter-score pairs are found.}

\item{kappa}{tunable parameter kappa of the upper confidence bound.
Adjusts exploitation/exploration. Increasing kappa will increase the
importance that uncertainty (unexplored space) has, therefore incentivising
exploration. This number represents the standard deviations above 0 of your upper
confidence bound. Default is 2.56, which corresponds to the ~99th percentile.}

\item{eps}{tunable parameter epsilon of ei, eips and poi. Adjusts exploitation/exploration.
This value is added to y_max after the scaling, so should between -0.1 and 0.1.
Increasing eps will make the "improvement" threshold for new points higher, therefore
incentivising exploitation.}

\item{gsPoints}{integer that specifies how many initial points to try when
searching for the optimum of the acquisition function. Increase this for a higher
chance to find global optimum, at the expense of more time.}

\item{convThresh}{convergence threshold passed to \code{factr} when the
\code{optim} function (L-BFGS-B) is called. Lower values will take longer
to converge, but may be more accurate.}

\item{minClusterUtility}{number 0-1. Represents the minimum percentage
of the optimal utility required for a less optimal local maximum to
be included as a candidate parameter set in the next scoring function.
If \code{NULL}, only the global optimum will be used as a candidate
parameter set. If 0.5, only local optimums with 50 percent of the global
optimum will be used.}

\item{noiseAdd}{Depreciated. Noise is added in increasing amounts until
unique parameter sets are found.}

\item{plotProgress}{Should the progress of the Bayesian optimization be
printed? Top graph shows the score(s) obtained at each iteration.
The bottom graph shows the optimal value of the acquisition function
at each iteration. This is useful to display how much utility the
Gaussian Process is actually assuming still exists. If your utility
is approaching 0, then you can be confident you are close to an optimal
parameter set.}

\item{verbose}{Whether or not to print progress to the console.
If 0, nothing will be printed. If 1, progress will be printed.
If 2, progress and information about new parameter-score pairs will be printed.}
}
\value{
A list containing details about the process:
\item{GPs}{The last Gaussian process run on the parameter-score pairs}
\item{GPe}{If \code{acq = "eips"}, this contains the last Gaussian Process run on the parameter-elapsed time pairs}
\item{progressPlot}{a Plotly chart showing the evolution of the scores
and utility discovered during the Bayesian optimization}
\item{ScoreDT}{A list of all parameter-score pairs, as well as extra columns
from FUN. gpUtility is the acquisition function value at the time that parameter
set was tested. acqOptimum is a boolean column that specifies whether the parameter
set was an acquisition function optimum, or if it was obtained by applying noise
to another optimum. Elapsed is the amount of time in seconds it took FUN to
evaluate that parameter set.}
\item{BestPars}{The best parameter set at each iteration}
}
\description{
This function is depreciated. Please use \code{bayesOpt} instead.
}
\references{
Jasper Snoek, Hugo Larochelle, Ryan P. Adams (2012) \emph{Practical Bayesian Optimization of Machine Learning Algorithms}
}
