% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelEstimateObject.R
\name{summary.PanelEstimate}
\alias{summary.PanelEstimate}
\title{Get summaries of PanelEstimate objects/calculations}
\usage{
\method{summary}{PanelEstimate}(object, verbose = TRUE, bias.corrected = FALSE, ...)
}
\arguments{
\item{object}{A PanelEstimate object}

\item{verbose}{logical indicating whether or not output should be printed in an expanded form. Default is TRUE}

\item{bias.corrected}{logical indicating whether or not bias corrected estimates should be provided. Default is FALSE. This argument only applies for standard errors calculated with the bootstrap.}

\item{...}{optional additional arguments. Currently, no additional arguments are supported.}
}
\description{
\code{summary.PanelEstimate} takes an object returned by
\code{PanelEstimate}, and returns a summary table of point
estimates and confidence intervals
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
# create subset of data for simplicity
PM.results <- PanelMatch(lag = 4, time.id = "year", unit.id = "wbcode2", 
                         treatment = "dem", refinement.method = "ps.weight", 
                         data = dem.sub, match.missing = TRUE, 
                         covs.formula = ~ tradewb,
                         size.match = 5, qoi = "att",
                         outcome.var = "y", lead = 0:4, forbid.treatment.reversal = FALSE)
PE.results <- PanelEstimate(sets = PM.results, data = dem.sub, se.method = "unconditional")
summary(PE.results)



}
