% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history_menager.R
\name{get_active_conversation_id}
\alias{get_active_conversation_id}
\title{Gets the ID of the active conversation}
\usage{
get_active_conversation_id()
}
\value{
Character string or \code{NULL}. The ID of the currently active conversation,
or \code{NULL} if no conversation is active or if the previously active
conversation ID points to a conversation that no longer exists.
}
\description{
Retrieves the identifier of the conversation currently marked as active.
}
\examples{
# Setup
reset_history_manager()
conv_get_id <- create_new_conversation(activate = FALSE)

# Check when no conversation is active
print(paste("Active ID initially:", get_active_conversation_id())) # NULL

# Activate the conversation
set_active_conversation(conv_get_id)

# Get the active ID
print(paste("Active ID after set:", get_active_conversation_id())) # conv_get_id

# Deactivate
set_active_conversation(NULL)
print(paste("Active ID after unset:", get_active_conversation_id())) # NULL

# Clean up
reset_history_manager()
}
