% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lint.R
\name{lintScore}
\alias{lintScore}
\title{lintScore}
\usage{
lintScore(repo, messages)
}
\arguments{
\item{repo}{(\link[PaRe]{Repository})\cr
Repository object.}

\item{messages}{(\link[base]{data.frame})\cr
Data frame containing lintr messages. See \link[PaRe]{lintRepo}.}
}
\value{
(\link[dplyr]{tibble})
\describe{
\item{type}{(\link[base]{character}) Type of message.}
\item{pct}{(\link[base]{double}) Score.}
}
}
\description{
Function that scores the lintr output as a percentage per message type
(style, warning, error). Lintr messages / lines assessed * 100
}
\examples{
fetchedRepo <- tryCatch(
  {
    # Set dir to clone repository to.
    tempDir <- tempdir()
    pathToRepo <- file.path(tempDir, "glue")

    # Clone repo
    git2r::clone(
      url = "https://github.com/tidyverse/glue.git",
      local_path = pathToRepo
    )

    # Create instance of Repository object.
    repo <- PaRe::Repository$new(path = pathToRepo)

    # Set fetchedRepo to TRUE if all goes well.
    TRUE
  },
  error = function(e) {
    # Set fetchedRepo to FALSE if an error is encountered.
    FALSE
  },
  warning = function(w) {
    # Set fetchedRepo to FALSE if a warning is encountered.
    FALSE
  }
)

if (fetchedRepo) {
  messages <- lintRepo(repo = repo)

  # Run lintScore on the Repository object.
  lintScore(repo = repo, messages = messages)
}
}
