% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_loadAnnual.R
\name{wrcc_loadAnnual}
\alias{wrcc_loadAnnual}
\title{Load annual WRCC monitoring data}
\usage{
wrcc_loadAnnual(year = NULL, parameter = "PM2.5",
  baseUrl = "https://haze.airfire.org/monitoring", dataDir = NULL)
}
\arguments{
\item{year}{Desired year (integer or character representing YYYY).}

\item{parameter}{Parameter of interest.}

\item{baseUrl}{Base URL for 'annual' WRCC data files.}

\item{dataDir}{Local directory containing 'annual' data files.}
}
\value{
A \emph{ws_monitor} object with WRCC data.
}
\description{
Loads pre-generated .RData files containing annual
WRCC data.

If \code{dataDir} is defined, data will be loaded from this local
dirctory. Otherwise, data will be loaded from the monitoring data repository
maintained by PWFSL.

The annual files loaded by this function are updated on the 15'th of each
month and cover the period from the beginning of the year to the end of the
last month.

For data during the last 45 days, use \code{wrcc_loadDaily()}.

For the most recent data, use \code{wrcc_loadLatest()}.

WRCC parameters include the following:
\enumerate{
\item{PM2.5}
}

Available WRCC RData and associated log files can be seen at:
\href{https://haze.airfire.org/monitoring/WRCC/RData}{https://haze.airfire.org/monitoring/WRCC/RData}
}
\examples{
\dontrun{
wrcc_loadAnnual(2017) \%>\%
  monitor_subset(stateCodes='MT', tlim=c(20170701,20170930)) \%>\%
  monitor_dailyStatistic() \%>\%
  monitor_timeseriesPlot(style = 'gnats', ylim=c(0,300), xpd=NA)
  addAQIStackedBar()
  addAQILines()
  title("Montana 2017 -- WRCC Daily Average PM2.5")
}
}
\seealso{
\code{\link{wrcc_loadDaily}}

\code{\link{wrcc_loadLatest}}
}
\keyword{WRCC}
