% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_writeCurrentStatusGeoJSON.R
\name{monitor_writeCurrentStatusGeoJSON}
\alias{monitor_writeCurrentStatusGeoJSON}
\title{Write current monitor data to geojson file}
\usage{
monitor_writeCurrentStatusGeoJSON(
  ws_monitor,
  filename,
  datetime = lubridate::now(tzone = "UTC"),
  properties = NULL,
  propertyNames = NULL,
  metadataList = list()
)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object.}

\item{filename}{Filename where geojson file will be saved.}

\item{datetime}{Time to which data will be 'current' (integer or character
representing YYYYMMDDHH or \code{POSIXct}. If not \code{POSIXct},
interpreted as UTC time). So if \code{datetime} is 3 hours ago, a dataframe
with the most current data from 3 hours ago will be returned.}

\item{properties}{Optional character vector of properties to include for each
monitor in geoJSON. If NULL all are included. May include any ws_monitor
metadata and additional columns generated in
\code{\link{monitor_getCurrentStatus}}.}

\item{propertyNames}{Optional character vector supplying custom names for
properties in geoJSON. If NULL or different length than \code{properties}
defaults will be used.}

\item{metadataList}{List of top-level foreign members to include. May include
nested lists as long as they can be converted into JSON using
\code{jsonlite::toJSON()}. For more information on what can be included see
\href{https://tools.ietf.org/html/rfc7946#section-6.1}{https://tools.ietf.org/html/rfc7946#section-6.1}.}
}
\value{
Invisibly returns geoJSON string.
}
\description{
Writes a geoJSON file containing current monitor data. For details on what is
included, see \code{\link{monitor_getCurrentStatus}}.
}
\examples{
\donttest{
library(PWFSLSmoke)

wa <-
  monitor_loadLatest() \%>\%
  monitor_subset(stateCodes = "WA")

geojson_file <- tempfile(fileext = ".geojson")
wa_current_geojson <- monitor_writeCurrentStatusGeoJSON(wa, geojson_file)
wa_current_list <- jsonlite::fromJSON(wa_current_geojson)
wa_spdf <- rgdal::readOGR(dsn = geojson_file)
map("state", "washington")
points(wa_spdf)
}
}
\keyword{ws_monitor}
