% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitorPlot_timeOfDaySpaghetti.R
\name{monitorPlot_timeOfDaySpaghetti}
\alias{monitorPlot_timeOfDaySpaghetti}
\title{Create Time of Day Spaghetti Plot}
\usage{
monitorPlot_timeOfDaySpaghetti(ws_monitor, monitorID = NULL, tlim = NULL,
  ylim = NULL, aqiLines = TRUE, shadedNight = TRUE, title = NULL, ...)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{monitorID}{id for a specific monitor in the ws_monitor object}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH])}

\item{ylim}{y limits for the plot}

\item{aqiLines}{horizontal lines indicating AQI levels}

\item{shadedNight}{add nighttime shading based on of middle day in selected period}

\item{title}{plot title}

\item{...}{additional arguments to pass to \code{lines()}}
}
\description{
Creates a spaghetti plot of PM2.5 levels by hour for one or more days. The average by hour over 
the period is also calculated and plotted as a thick red line.
}
\examples{
monitorPlot_timeOfDaySpaghetti(Carmel_Valley, tlim=c(20160801,20160809))
}
\keyword{ws_monitor}
