% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrccDump_identifyMonitorType.R
\name{wrccDump_identifyMonitorType}
\alias{wrccDump_identifyMonitorType}
\title{Identify WRCC Dump File Monitor Type}
\usage{
wrccDump_identifyMonitorType(fileString)
}
\arguments{
\item{fileString}{character string containing WRCC dump file}
}
\value{
List including \code{monitorType}, \code{rawNames}, \code{columnNames} and \code{columnTypes}.
}
\description{
Examine the column names of the incoming character vector
to identify different types of monitor data provided by WRCC.

The return is a list includes everything needed to identify and parse the raw
data using \code{readr::read_csv()}:

\itemize{
\item{\code{monitorType}}{ -- identification string}
\item{\code{rawNames}}{ -- column names from the data (including special characters)}
\item{\code{columnNames}}{ -- assigned column names (special characters repaced with '.')}
\item{\code{columnTypes}}{ -- column type string for use with \code{readr::read_csv()}}
}

The \code{monitorType} will be one of:
\itemize{
\item{"\code{WRCC_TYPE1}"}{ -- ???}
\item{"\code{WRCC_TYPE2}"}{ -- ???}
\item{"\code{UNKOWN}"}{ -- ???}
}

This function is intended for internal use at the Pacific Wildland
Fire Sciences Lab.
}
\references{
\href{http://www.wrcc.dri.edu/cgi-bin/smoke.pl}{WRCC Fire Cache Smoke Monitor Archive}
}
\keyword{internal}

