% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_nowcast.R
\name{monitor_nowcast}
\alias{monitor_nowcast}
\title{Apply Nowcast Algorithm to ws_monitor Object}
\usage{
monitor_nowcast(ws_monitor, version = "pm")
}
\arguments{
\item{ws_monitor}{emph{ws_monitor} object}

\item{version}{character identity specifying the type of nowcast algorithm to be used}
}
\value{
A emph{ws_monitor} object with data that have been processed by the Nowcast algorithm.
}
\description{
A Nowcast algorithm is applied to the data in in the ws_monitor object. The 
\code{version} argument specifies the minimum weight factor and number of hours to be 
considered in the calculation.

Available versions include:
\enumerate{
\item{pm}{hours=12, weight=0.5}
\item{pmAsian}{hours=3, weight=0.1}
\item{ozone}{hours=8, weight=NA}
}

See the references for details. The default, \code{version='pm'}, is appropriate
for typical usage.
}
\note{
Calculated Nowcast values are rounded to the nearest .1 for 'pm' and nearest
.001 for 'ozone' regardless of the precision of the data in the incoming \emph{ws_monitor} object.
}
\examples{
N_M <- monitor_subset(Northwest_Megafires, tlim=c(20150815,20150831))
Omak <- monitor_subset(N_M, monitorIDs='530470013')
Omak_nowcast <- monitor_nowcast(Omak)
monitorPlot_timeseries(Omak, type='l', lwd=2)
monitorPlot_timeseries(Omak_nowcast, add=TRUE, type='l', col='purple', lwd=2)
addAQILines()
addAQILegend(lwd=1, pch=NULL)
legend("topleft", lwd=2, col=c('black','purple'), legend=c('hourly','nowcast'))
title("Omak, Washington Hourly and Nowcast PM2.5 Values in August, 2015")
}
\references{
\url{https://en.wikipedia.org/wiki/Nowcast_(Air_Quality_Index)}

\url{https://www3.epa.gov/airnow/ani/pm25_aqi_reporting_nowcast_overview.pdf}

\url{https://aqicn.org/faq/2015-03-15/air-quality-nowcast-a-beginners-guide/}
}
\keyword{ws_monitor}

