% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_subset.R
\name{monitor_subset}
\alias{monitor_subset}
\title{Create a Subset of a ws_monitor Object}
\usage{
monitor_subset(ws_monitor, xlim = NULL, ylim = NULL, tlim = NULL,
  vlim = NULL, monitorIDs = NULL, stateCodes = NULL,
  countryCodes = NULL, dropMonitors = TRUE, timezone = "UTC")
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{xlim}{optional vector with low and high longitude limits}

\item{ylim}{optional vector with low and high latitude limits}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH] or \code{POSIXct})}

\item{vlim}{optional vector with low and high data value limits}

\item{monitorIDs}{optional vector of monitor IDs used to filter the data}

\item{stateCodes}{optional vector of state codes used to filter the data}

\item{countryCodes}{optional vector of country codes used to filter the data}

\item{dropMonitors}{flag specifying whether to remove monitors with no data}

\item{timezone}{Olson timezone passed to \code{link{parseDatetime}} when parsing numeric \code{tlim}}
}
\value{
A \emph{ws_monitor} object with a subset of \code{ws_monitor}.
}
\description{
Creates a subset \emph{ws_monitor} based on one or more optional input parameters.
If any input parameter is not specified, that parameter will not be used to subset \code{ws_monitor}.
}
\details{
By default, this function will return a \emph{ws_monitor} object whose \code{data} dataframe has the
same number of columns as the incoming dataframe, unless any of the columns consist of all \code{NA}s, 
in which case such columns will be removed (\emph{e.g.} if there are no valid data for a specific monitor 
after subsetting by \code{tlim} or \code{vlim}).
If \code{dropMonitors=FALSE}, columns that consist of all \code{NA}s will be retained.
}
\examples{
N_M <- monitor_subset(Northwest_Megafires, tlim=c(20150701,20150731))
xlim <- c(-124.73, -122.80)
ylim <- c(47.20, 48.40)
Olympic_Peninsula <- monitor_subset(N_M, xlim, ylim)
monitorMap(Olympic_Peninsula, cex=2)
rect(xlim[1], ylim[1], xlim[2], ylim[2], col=adjustcolor('black',0.1))
}
\keyword{ws_monitor}
