% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epa_createMetaDataframe.R
\name{epa_createMetaDataframe}
\alias{epa_createMetaDataframe}
\title{Create Sites Metadata Dataframe}
\usage{
epa_createMetaDataframe(df)
}
\arguments{
\item{df}{an EPA raw dataframe after metadata enhancement}
}
\value{
A \code{meta} dataframe for use in a \emph{ws_monitor} object.
}
\description{
After addtional columns(i.e. \code{datetime}, and \code{monitorID}) 
have been applied to an EPA dataframe, we are ready to 
pull out site information associated with unique monitorID.

These will be rearranged into a dataframe organized as deployment-by-property
with one row for each monitorID.

This site information found in \code{df} is augmented so that we end up with a uniform
set of properties associated with each monitorID. The list of
columns in the returned \code{meta} dataframe is:

\preformatted{
> names(meta)
[1] "monitorID"        "siteName"         "latitude"         "longitude"        "elevation"        "timezone"         "stateCode"       
[8] "Site.Num"         "Parameter.Code"   "POC"              "Units.of.Measure" "MDL"              "Method.Type"      "Method.Name"     
[15] "State.Name"       "County.Name" 
}
}
\keyword{EPA}
