% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-code.R
\name{loglik.norm.LR.Rcpp}
\alias{loglik.norm.LR.Rcpp}
\title{Compute Marginal Predictive Loglikelihood of Data Given alpha}
\usage{
loglik.norm.LR.Rcpp(y, X = FALSE, alpha, init)
}
\arguments{
\item{y}{T-length time series vector.  y[1] represents the beginning of
the time eries.}

\item{X}{[T x p] dimensional matrix of covariates. This should not 
include the intercept column. If X is FALSE, intercept model is run.}

\item{alpha}{PWD parameter we are calculating the marginal predictive
loglikelihood for.}

\item{init}{integer representing the time point to begin computing marginal
predictive loglikelihood.}
}
\value{
Return a scalar value representing the marginal predictive 
loglikelihood of the data given alpha.
}
\description{
This function computes the marginal predictive loglikelihood of the 
observed data given a particular value of alpha, and the time
point to begin computing marginal predictive loglikelihoods.
}
\examples{
N=80
err = rnorm(N)
X = 1:N
slopes = c(rep(1.5,40),rep(2,N-40))
y = rep(5,N) + slopes*X + err                  
init=4
alpha.grid = seq(.65,1,length.out=40)
i=40
loglik.norm.LR.Rcpp(y,X=X,alpha=alpha.grid[i],init=init)
}

