% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-code.R
\name{bhat.func}
\alias{bhat.func}
\title{Compute PWD Regression Coefficients Given alpha}
\usage{
bhat.func(y, X, alpha)
}
\arguments{
\item{y}{T-length time series vector.  y[1] represents the beginning of
the time eries.}

\item{X}{[T x p] dimensional matrix of covariates. This should not 
include the intercept column. If X is FALSE, intercept model is run.}

\item{alpha}{PWD parameter we are calculating the marginal predictive
loglikelihood for.}
}
\value{
(p+1)-length vector representing the regression coefficients
associated with a PWD regression of y upon X given PWD parameter alpha.
}
\description{
This function computes PWD regression coefficients for response
y and predictors X given a particular value of alpha.
}
\examples{
set.seed(12)
N=80
err = rnorm(N)
X = 1:N
slopes = c(rep(1.5,40),rep(2,N-40))
y = rep(5,N) + slopes*X + err                  
alpha1 = 1.0
coeffs1 = bhat.func(y,X,alpha1)
alpha2 = .9
coeffs2 = bhat.func(y,X,alpha2)
plot(x=X,y=y)
abline(a=coeffs2[1],b=coeffs2[2],lty=2,col="red")
abline(a=coeffs1[1],b=coeffs1[2],lty=2)
legend("right", legend=c("OLS","PWD"), col=c(1,2), lty=c(2,2), lwd=c(1,1))
}

