% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_corrections.R
\name{plr_6k_model}
\alias{plr_6k_model}
\title{6k Method for PLR Determination}
\usage{
plr_6k_model(
  df,
  var_list,
  nameplate_power,
  by = "month",
  data_cutoff = 30,
  predict_data = NULL
)
}
\arguments{
\item{df}{A dataframe containing pv data.}

\item{var_list}{A list of the dataframe's standard variable names, obtained from
the output of \code{\link{plr_variable_check}}.}

\item{nameplate_power}{The rated power capability of the system, in watts.}

\item{by}{String, either "day", "week", or "month". The time periods over which
to group data for regression.}

\item{data_cutoff}{The number of data points needed to keep a value in the 
final table. Regressions over less than this number and their data will be discarded.}

\item{predict_data}{optional; Dataframe; If you have preferred estimations of irradiance,
temperature, and wind speed, include them here to skip automatic generation. Format:
Irradiance, Temperature, Wind (optional).}
}
\value{
Returns dataframe of results per passed time scale from 6K modeling
}
\description{
This function groups data by the specified time interval
and performs a linear regression using the formula: 
 power_var ~ irrad_var/istc * 
 (nameplate_power + 
 a*log(irrad_var/istc) + 
 b*log(irrad_var/istc)^2 +
  c*(temp_var - tref) + 
 d*(temp_var - tref)*log(irrad_var/istc) + 
 e*(temp_var - tref)*log(irrad_var/istc)^2 + 
 f*(temp_var - tref)^2).
Predicted values of irradiance, temperature, and wind speed (if applicable)
 are added for reference. These values are the lowest daily high
irradiance reading (over 300W/m^2), the average temperature over all data, and
the average wind speed over all data.
}
