% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.grpPUlasso.R
\name{cv.grpPUlasso}
\alias{cv.grpPUlasso}
\title{Cross-validation for PUlasso}
\usage{
cv.grpPUlasso(X, z, pi, initial_coef = NULL, group = 1:ncol(X),
  penalty = NULL, lambda = NULL, nlambda = 100,
  lambdaMinRatio = ifelse(N < p, 0.05, 0.005), maxit = 1e+05, eps = 1e-04,
  inner_eps = 0.01, verbose = FALSE, nfolds = 10, nfits = nfolds,
  nCores = 1)
}
\arguments{
\item{X}{Input matrix; each row is an observation. Can be a matrix or a sparse matrix.}

\item{z}{Response vector representing whether an observation is labelled or unlabelled.}

\item{pi}{True prevalence Pr(Y=1)}

\item{initial_coef}{A vector representing an initial point where we start PUlasso algorithm from.}

\item{group}{A vector representing grouping of the coefficients. For the least ambiguity, it is recommended if group is provided in the form of vector of consecutive ascending integers.}

\item{penalty}{penalty to be applied to the model. Default is sqrt(group size) for each of the group.}

\item{lambda}{A user supplied sequence of lambda values. If unspecified, the function automatically generates its own lambda sequence based on nlambda and lambdaMinRatio.}

\item{nlambda}{The number of lambda values.}

\item{lambdaMinRatio}{Smallest value for lambda, as a fraction of lambda.max which leads to the intercept only model.}

\item{maxit}{Maximum number of iterations.}

\item{eps}{Convergence threshold for the outer loop. The algorithm iterates until the maximum change in coefficients is less than eps in the outer loop.}

\item{inner_eps}{Convergence threshold for the inner loop. The algorithm iterates until the maximum change in coefficients is less than eps in the inner loop.}

\item{verbose}{A logical value. if TRUE, the function prints out the fitting process.}

\item{nfolds}{Number of cross-validation folds to be created.}

\item{nfits}{Number of cross-validation models which will be fitted. Default is to fit the model for each of the cross-validation fold.}

\item{nCores}{Number of OpenMP threads to be used for parallel computing. If nCores=0, it is set to be the number of processors available. Default value is 1.}
}
\value{
cvm Mean cross-validation error

cvsd Estimate of standard error of cvm

cvcoef Coefficients for each of the fitted CV models

cvstdcoef Coefficients in a standardized scale for each of the fitted CV models

lambda The actual sequence of lambda values used.

lambda.min Value of lambda that gives minimum cvm.

lambda.1se The largest value of lambda such that the error is within 1 standard error of the minimum cvm.

PUfit A fitted PUfit object for the full data
}
\description{
Do a n-fold cross-validation for PUlasso.
}
\examples{
data("simulPU")
fit<-cv.grpPUlasso(X=simulPU$X,z=simulPU$z,pi=simulPU$truePY1)
}
