% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bid.lm.r
\name{bid.lm}
\alias{bid.lm}
\title{Linear Boyd Intraparticle Diffusion Model}
\usage{
bid.lm(t, qt, qinf)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{qt}{the numerical value for the amount adsorbed at time t}

\item{qinf}{the numerical value for the amount adsorbed at infinite time}
}
\value{
the linear regression and the parameter estimation for the Boyd Intraparticle Diffusion model
}
\description{
The Boyd Intraparticle Diffusion Model is frequently applied to analyze if intraparticle diffusion governs the experimental kinetic data. This model assumes that the boundary layer surrounding the adsorbent has a greater effect on the diffusion of solute (Viegas, Campinas, Costa, and Rosa, 2014).
}
\examples{
\donttest{
t <- c(0,15,30,45,60,75,90,105,120)
qt <-c(0.000,3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
qinf <- 4.8
bid.lm(t,qt,qinf)}
}
\references{
Boyd, G. E., Adamson, A. W., & Myers, L. S. (1947) <doi:10.1021/ja01203a066> The Exchange Adsorption of Ions from Aqueous Solutions by Organic Zeolites. II. Kinetics1. Journal of the American Chemical Society, 69(11), 2836-2848.

Viegas, R. M. C., Campinas, M., Costa, H., &; Rosa, M. J. (2014) <doi:10.1007/s10450-014-9617-9> How do the HSDM and Boyd's model compare for estimating intraparticle diffusion coefficients in adsorption processes. Adsorption, 20(5-6), 737-746.
}
\author{
Jeff Ryan S. Magalong

Joshua Z. Dela Cruz

Jeann M. Bumatay

Chester C. Deocaris
}
