% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tothanalysis.R
\name{tothanalysis}
\alias{tothanalysis}
\title{Toth Isotherm  Nonlinear Analysis}
\usage{
tothanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the fractional coverage}
}
\value{
the nonlinear regression, parameters for Toth isotherm, and
model error analysis
}
\description{
Another empirical modification of the Langmuir equation with the
aim of reducing the error between experimental data and predicted value of
equilibrium data.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
tothanalysis(Ce,Qe)
}
\references{
Toth, J. (1971). State equations of the solid gas interface layer.
Acta Chem. Acad. Hung. 69:311-317
}
\author{
Keith T. Ostan

Chester C. Deocaris
}
