% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MzQC_classes.R
\docType{class}
\name{MzQCcvParameter-class}
\alias{MzQCcvParameter-class}
\alias{MzQCcvParameter}
\title{An controlled vocabulary parameter, as detailed in the OBO file}
\description{
An controlled vocabulary parameter, as detailed in the OBO file
}
\section{Fields}{

\describe{
\item{\code{accession}}{Accession number identifying the term within its controlled vocabulary (pattern: ^[A-Z]+:[A-Z0-9]+$).}

\item{\code{name}}{Name of the controlled vocabulary term describing the parameter.}

\item{\code{value}}{[optional] Value of the parameter.}

\item{\code{description}}{[optional] Definition of the controlled vocabulary term.}
}}


\examples{
  MzQCcvParameter$new("QC:4000139",
                      "RT acquisition range",
                      c(0.2959, 5969.8172))
  isValidMzQC(MzQCcvParameter$new("MS:0000000"))
   
}
