% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_misc.R
\name{mosaicize}
\alias{mosaicize}
\title{Prepare a Mosaic plot of two columns in long format.}
\usage{
mosaicize(data)
}
\arguments{
\item{data}{A data.frame with exactly two columns}
}
\value{
Data.frame
}
\description{
Found at http://stackoverflow.com/questions/19233365/how-to-create-a-marimekko-mosaic-plot-in-ggplot2
Modified (e.g. to pass R check)
}
\details{
Returns a data frame, which can be used for plotting and has the following columns:
'Var1' - marginalized values from 1st input column
'Var2' - marginalized values from 2nd input column
'Freq' - relative frequency of the combination given in [Var1, Var2]
'margin_var1' - frequency of the value given in Var1
'var2_height' - frequency of the value given in Var2, relative to Var1
'var1_center' - X-position when plotting (large sets get a larger share)
}
\examples{
  data = data.frame(raw.file = c(rep('file A', 100), rep('file B', 40)),
                    charge = c(rep(2, 60), rep(3, 30), rep(4, 10),
                               rep(2, 30), rep(3, 7), rep(4, 3)))
  mosaicize(data)                             
  
}

