% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSPMdemo.R
\name{PSPMdemo}
\alias{PSPMdemo}
\title{Demographic analysis of a structured population model}
\usage{
PSPMdemo(modelname = NULL, curvepars = NULL, parameters = NULL,
  options = NULL, clean = FALSE, force = FALSE, debug = FALSE,
  silent = FALSE)
}
\arguments{
\item{modelname}{(string, required)
\preformatted{}
              Basename of the file with model specification. The file
              should have extension ".h". For example, the model "Medfly"
              is specified in the file "Medfly.h". If the model is specified in R
              include the .R extension explicitly, i.e. specify the model name
              as "Medfly.R"}

\item{curvepars}{(row vector, optional, can be left equal to its default NULL)
\preformatted{}
              Vector of length 5, specifying:
\preformatted{}
              \verb{curvepars[1]}: the index of the parameter to vary
              (in case the model is specified in R, this can be
              a string with the name of the parameter as specified
              in the variable 'DefaultParameters')
\preformatted{}
              \verb{curvepars[2]}: the initial value of the parameter
\preformatted{}
              \verb{curvepars[3]}: the step size in the parameter value
\preformatted{}
              \verb{curvepars[4]}: lower threshold, below which value of the
              parameter the computation stops
\preformatted{}
              \verb{curvepars[5]}: upper threshold, above which value of the
              parameter the computation stops}

\item{parameters}{(row vector, optional, can be left equal to its default NULL)
\preformatted{}
              Vector of length PARAMETER_NR (set in the model program
              file; This is the length of the variable 'DefaultParameters' if the
              model is specified in R), specifying the values for the model
              parameters to use in the computation. Vectors of other lengths,
              including an empty vector will be ignored.}

\item{options}{(row vector of strings, optional, can be left equal to its default NULL)
\preformatted{}
              Vector with pairs of strings, consisting of an option name and a value (for
              example c("isort", "1")) or single options (i.e. c("test")).
              Possible option names and their values are:
\preformatted{}
              \verb{"isort", "<index>"}: Index of i-state variable to use as
                     ruling variable for sorting the
                     structured populations
\preformatted{}
              \verb{"report", "<value>"}: Interval between consecutive output of 
                     computed points to the console ( >= 1). Minimum value of 1 
                     implies output of every point
\preformatted{}
              \verb{"test"}: Perform only a single integration over
                     the life history, reporting dynamics
                     of survival, R0, i-state and
                     interaction variables}

\item{clean}{(Boolean, optional argument)
\preformatted{}
              Specify clean = TRUE as argument to remove all the result files
              of the model before the computation}

\item{force}{(Boolean, optional argument)
\preformatted{}
              Specify force = TRUE as argument to force a rebuilding of the model
              before the computation}

\item{debug}{(Boolean, optional argument)
\preformatted{}
              Specify debug = TRUE as argument to compile the model in verbose
              mode and with debugging flag set}

\item{silent}{(Boolean, optional argument)
\preformatted{}
              Specify silent = TRUE as argument to suppress reporting of compilation
              commands and results on the console}
}
\value{
The output is a list containing the following elements:
\preformatted{}
\verb{curvepoints}: Matrix with output for all computed points along the curve
\preformatted{}
\verb{curvedesc}: Column vector with strings, summarizing the numerical details
             of the computed curve (i.e., initial point, parameter values,
             numerical settings used).
}
\description{
\code{PSPMdemo} computes the population growth rate of a physiologically structured
population model and its sensitivities with respect to all model parameters.
\code{PSPMdemo} either carries out these computation for a single parameter set or
varies one of the parameters over a range of values specified by the user
}
\details{
output <- PSPMdemo(modelname = NULL, curvepars = NULL, parameters = NULL, options = NULL,
                     clean = FALSE, force = FALSE, debug = FALSE, silent = FALSE)
}
\examples{
\dontrun{
PSPMdemo("Medfly", c(2, 11, 0.1, 11, 16))
}

}
