% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_for_w_plot.R
\name{pred_for_w_plot}
\alias{pred_for_w_plot}
\title{It predict the values for given data, Window size (W) and Cluster size (k).}
\usage{
pred_for_w_plot(data_in, w, k, next_val)
}
\arguments{
\item{data_in}{as Input data, in any format (data matrix data frame or vector). All variables should be numeric and NA values will get removed while execution.}

\item{w}{as window size (Can be obtained with function "optimum_w")}

\item{k}{as cluster size for Kmeans (Can be obtained with function "optimum_k")}

\item{next_val}{as Integer number. It states the number of predicted values to be obtained.}
}
\value{
deno_prediction as predicted value
}
\description{
Takes Time Series data and Window size as Input
}
\examples{
## Generate 100 random numbers within some limits
x <- sample(1:7, 100, replace = TRUE)      #data_in = x
## Consider, w = 3, K = 4, next_val = 5
pred_for_w(x, 3, 4, 5)
}

