% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.weighting.R
\name{boot.weighting}
\alias{boot.weighting}
\title{Propensity score weighting implementation for bootstrapping.}
\usage{
boot.weighting(Tr, Y, X, X.trans, formu, estimand = "ATE", ...)
}
\arguments{
\item{Tr}{vector indicating treatment assignment.}

\item{Y}{vector of outcome.}

\item{X}{matrix or data frame of covariates.}

\item{X.trans}{a data frame of \code{X} with factors recoded. See \code{\link{cv.trans.psa}}}

\item{formu}{the formula to use to estimate propensity scores. Note that the
dependent varaible (i.e. treatment varaible) name will be updated using
the \code{Tr} vector.}

\item{estimand}{which treatment effect to estimate. Values can be ATE, ATT,
ATC, or ATM.}

\item{...}{other parameters passed from \code{\link{PSAboot}}}
}
\value{
a list with three elements:
        \describe{
        \item{\code{summary}}{a named numeric vector (with at minimum \code{estimate}, 
        \code{ci.min}, and \code{ci.max} but other values allowed)}
        \item{\code{balance}}{a named numeric vector with one element per 
        covariate listed in \code{X.trans} representing a balance statistic 
        (usually standardized effect size after adjustment)}
        \item{\code{details}}{an arbitrary object that contains the full results of the
        analysis}
        }
}
\description{
Propensity score weighting implementation for bootstrapping.
}
