% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.function.R
\name{kernel.function}
\alias{kernel.function}
\title{kernel.function}
\usage{
kernel.function(u, kernel = "normal", product = TRUE)
}
\arguments{
\item{u}{n x d matrix}

\item{kernel}{text string}

\item{product}{or spherical kernel if d>1}
}
\value{
matrix with diagonal elements set to \code{x}
}
\description{
\code{kernel.function} calculates several kernel functions (uniform, triangle, epanechnikov, biweight, triweight, gaussian).
}
\details{
slightly modified version of the kernel.function from the gplm package. The kernel parameter is a text string specifying the univariate kernel function which is either the gaussian pdf or proportional to (1-|u|^p)^q. Possible text strings are "triangle" (p=q=1), "uniform" (p=1, q=0), "epanechnikov" (p=2, q=1), "biweight" or "quartic" (p=q=2), "triweight" (p=2, q=3), "gaussian" or "normal" (gaussian pdf).
The multivariate kernels are obtained by a product of unvariate kernels K(u_1)...K(u_d) or by a spherical (radially symmetric) kernel proportional to K(||u||). (The resulting kernel is a density, i.e. integrates to 1.)
}
\keyword{kernel}

