% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPPggparty.R
\name{pp_ggparty}
\alias{pp_ggparty}
\title{PPTreereg plot with independent variable}
\usage{
pp_ggparty(PPTreeregOBJ,ind_variable,final.rule=5,Rule=1, ...)
}
\arguments{
\item{PPTreeregOBJ}{PPTreereg class object}

\item{ind_variable}{independent variable to show}

\item{final.rule}{final rule to assign numerical values in the final nodes.
1: mean value in the final nodes
2: median value in the final nodes
3: using optimal projection
4: using all independent variables
5: using several significant independent variables}

\item{Rule}{split rule
1: mean of two group means
2: weighted mean of two group means - weight with group size
3: weighted mean of two group means - weight with group sd
4: weighted mean of two group means - weight with group se
5: mean of two group medians
6: weighted mean of two group medians - weight with group size
7: weighted mean of two group median - weight with group IQR
8: weighted mean of two group median - weight with group IQR
                                       and group size}

\item{...}{arguments to be passed to methods}
}
\value{
An object of the class \code{ggplot}
}
\description{
projection pursuit regression tree plot with independent variable
}
\details{
Draw projection pursuit regression tree with independent variable. It is modified
from a function in \code{partykit} library.
}
\examples{
data(dataXY)
Model <- PPTreereg(Y~., data = dataXY, DEPTH = 2)
pp_ggparty(Model, "X1", final.rule=5)

}
\keyword{tree}
