% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryPOUMM.R
\name{summary.POUMM}
\alias{summary.POUMM}
\title{Summarize the results of a POUMM-fit}
\usage{
\method{summary}{POUMM}(object, ..., startMCMC = NA, endMCMC = NA,
  thinMCMC = 1000, stats = statistics(object), mode = c("short",
  "long", "expert"))
}
\arguments{
\item{object}{a POUMM object returned by POUMM-function (see ?POUMM).}

\item{...}{Not used, but declared for consistency with the generic method summary.}

\item{startMCMC, endMCMC}{integers indicating the range of the MCMC chains
to be used for the analysis (excluding the initial warm-up phase)}

\item{thinMCMC}{thinning interval of the MCMC chain to avoid strong 
autocorrelation between sampled elements;}

\item{stats}{a named list of functions of the form function(par) { number },
which are called for each sample of each mcmc chain in object. Defaults to 
a call of statistics(object) returning a list of statistics functions relevant for 
the object. See also statistics.}

\item{mode}{a character indicating the desired format of the returned summary 
as follows:
'short' - a data.table with the ML and MCMC estimates of heritability, 
model parameters, root-value and other statistics. 
'long' - same information as in 'short' but including also the samples, which
can be convenient for}
}
\description{
Summarize the results of a POUMM-fit
}
