% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPOUMM.R
\name{MCMC}
\alias{MCMC}
\title{(Adaptive) Metropolis Sampler}
\usage{
MCMC(p, n, init, scale = rep(1, length(init)), adapt = !is.null(acc.rate),
  acc.rate = NULL, gamma = 0.5, list = TRUE, n.start = 0, ...)
}
\arguments{
\item{p}{function that returns the log probability density to sample from. 
Must have two or more dimensions. In this changed version the function can 
return a vector, the first element of which is the log-propbability.}

\item{n}{number of samples.}

\item{init}{vector with initial values.}

\item{scale}{vector with the variances or covariance matrix of the jump
distribution.}

\item{adapt}{if TRUE, adaptive sampling is used, if FALSE classic metropolis
sampling, if a positive integer the adaption stops after adapt iterations.}

\item{acc.rate}{desired acceptance rate (ignored if adapt=FALSE)}

\item{gamma}{controls the speed of adaption. Should be between 0.5 and 1. A
lower gamma leads to faster adaption.}

\item{list}{logical. If TRUE a list is returned otherwise only a matrix with 
the samples.}

\item{n.start}{teration where the adaption starts. Only internally used.}

\item{...}{further arguments passed to p.}
}
\value{
Same list as the one returned from adaptMCMC::MCMC but the member 
  log.p is a matrix instead of a vector.
}
\description{
Copied and modified from Andreas Scheidegger's adaptMCMC 
  package. The only difference is that the function p can return a vector 
  instead of a single numeric. The first element of this vector is the 
  log-posterior, while the other elements can be any additional information 
  such as the log-likelihood, or the root-value for that log-likelihood in 
  the case of POUMM.
}

