% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersection.R
\name{intersection}
\alias{intersection}
\alias{\%it\%}
\title{Intersection of two posets}
\usage{
intersection(x, y)

x \%it\% y
}
\arguments{
\item{x}{an S4 object of class \code{Rcpp_POSet}, see \code{\link[POSetR]{poset}} for details.}

\item{y}{an S4 object of class \code{Rcpp_POSet}, see \code{\link[POSetR]{poset}} for details.}
}
\value{
an S4 object of class \code{Rcpp_POSet}, see \code{\link[POSetR]{poset}} for details
}
\description{
Given two posets \code{X} and \code{Y} on the same set, \code{intersection} returns the poset Z defined by \code{a < b} in \code{Z} if and only if \code{a < b} in \code{X} and \code{a < b} in \code{Y}.
}
\examples{
dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)
p <- poset(x = dom)
plot(p)
dom <- matrix(c(
  "a", "b",
  "c", "b",
  "d", "b"
), ncol = 2, byrow = TRUE)
q <- poset(x = dom)
plot(q)
plot(p \%it\% q)

}
\references{
\insertRef{davey2002introduction}{POSetR}
}
\seealso{
\code{\link[POSetR]{poset}}
}
