% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdemog.R
\name{PlotMig}
\alias{PlotMig}
\title{Plot migration event(s) at a particular time}
\usage{
PlotMig(time_pt = NULL, event = 1, mig_par, demograph_out,
  size.scale = mig_par$size.scale, time.scale = mig_par$time.scale,
  linear.scale = mig_par$linear.scale, log.base = mig_par$log.base,
  col.pop = mig_par$col.pop, col.arrow = mig_par$col.arrow,
  xlim = mig_par$xlim, ylim = mig_par$ylim, lwd.arrow = mig_par$lwd.arrow,
  length.arrowtip = mig_par$length.arrowtip,
  angle.arrowtip = mig_par$angle.arrowtip, toposize.scale = 1,
  add = FALSE, map.pos = NULL, m.adjust = 0)
}
\arguments{
\item{time_pt}{A numeric value defining the time point for the migrations which will be plotted. \code{time_pt} should be in the scale defined by \code{time.scale}. For example, \code{time_pt} = 3 when \code{time.scale} = "log10year" corresponds to the migrations 10^3 years ago.}

\item{event}{An index to define at which time to plot migration(s). Every demographic event has an index in the order of time. Demographic changes at the same time are all defined as the same event and share the same index.}

\item{mig_par}{A list contained all settings for plotting the demographic graph, see \code{\link{PlotMS}}.}

\item{demograph_out}{A list containing all demographic information, see \code{\link{PlotMS}}.}

\item{size.scale}{A keyword to define the scaling of lineage width. "topology" returns only topology structure among simulated populations, ignoring both the population sizes and the length of time between any demographic events. "linear" linearly scales the lineage widths as a function of the population size, with the scale factor defined by the variable \code{linear.scale}; "log" scales the lineage width logarithmically as a function of the population size. The logarithm base is defined by the variable \code{log.base}.}

\item{time.scale}{A keyword to define the time scale used in the plot. It can be "4Ne", "generation", "year", "kyear", and "log10year". When the \code{size.scale} = "topology", this parameter will be ignored.}

\item{linear.scale}{Linear scale magnitude, to be applied when \code{size.scale} = "linear".}

\item{log.base}{The base of logarithm, to be applied when \code{size.scale} = "log".}

\item{col.pop}{Population lineage color.}

\item{col.arrow}{Migration arrow color.}

\item{xlim}{The range of x-axis.}

\item{ylim}{The range of y-axis.}

\item{lwd.arrow}{Control the line width of arrow representing a migration. The arrow width is defined by 0.5+migration strength*\code{lwd.arrow}.}

\item{length.arrowtip}{Length of the edges of the arrow tip.}

\item{angle.arrowtip}{The angle of the arrow tip, between 0 and 90.}

\item{toposize.scale}{Control the scaling of the size of circle when the \code{size.scale} = "topology".}

\item{add}{A logical value allowing one to add the migrations to another background (2-D only). Positions for every population dime should be defined in \code{map.pos}.}

\item{map.pos}{A matrix with two columns, the ith row is the coordinate for the ith population.}

\item{m.adjust}{Migration threshold for plotting migration events. Migration events with strength higher than \code{m.adjust} will be shown. The migration strength is defined as the proportion of the target population being replaced by the source population per generation. Default value is 0.}
}
\description{
This function plots migration events at a particular time point based on the output of \code{PlotMS} with \code{demo.out} = T and \code{plot.out} = F. The \code{time_pt} or \code{event} determines the time points that are plotted. The \code{add} and \code{map.pos} parameters allow the migration graph to be added to other backgrounds such as maps.
}
\examples{
test.mig.cmd <- "./ms 15 100 -t 3.0 -I 6 0 7 0 0 8 0 -m 1 2 2.5 -m 2 1 2.5 
-m 2 3 2.5 -m 3 2 2.5 -m 4 5 2.5 -m 5 4 2.5 -m 5 6 2.5 -m 6 5 2.5 
-em 2.0 3 4 2.5 -em 2.0 4 3 2.5"
out <- PlotMS(input.cmd = test.mig.cmd, type = "ms", 
N4 = 10000, plot.out = FALSE, demo.out = TRUE);
#check all migration events
events <- out$mig_par$events
print(events)
#check the time for those migration events
timeofevents <- out$mig_par$time[events]
print(timeofevents)
#plot event by event
par(mfrow = c(1, 2))
PlotMig(event = 1, demograph_out = out$demograph_out, mig_par = out$mig_par)
title("Event-1");
PlotMig(event = 2, demograph_out = out$demograph_out, mig_par = out$mig_par, 
col.pop = 1:6, xlim = c(-5,4))
title("Event-2", cex.main = 3);
legend("topleft", col = 1:6, pch = 20, bty = "n", cex = 2,
legend = c("pop-1", "pop-2", "pop-3", "pop-4", "pop-5", "pop-6"))
}
\seealso{
\code{\link{PlotMS}}
}
