% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frdAllPairsNemenyiTest.R
\name{frdAllPairsNemenyiTest}
\alias{frdAllPairsNemenyiTest}
\alias{frdAllPairsNemenyiTest.default}
\alias{frdAllPairsNemenyiTest.formula}
\title{Nemenyi's All-Pairs Comparisons Test for Unreplicated Blocked Data}
\usage{
frdAllPairsNemenyiTest(y, ...)

\method{frdAllPairsNemenyiTest}{default}(y, groups, blocks, ...)

\method{frdAllPairsNemenyiTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{y}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{groups}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}. Ignored with a warning if \code{"x"} is a list.}

\item{blocks}{a vector or factor object giving the block for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{a ~ b | c} where
\code{a, b} and \code{c} give the data values and
the corresponding groups and blocks, respectively.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}

\item{\ldots}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Nemenyi's all-pairs comparisons tests of Friedman-type ranked data.
}
\details{
For all-pairs comparisons in a two factorial unreplicated
complete block design
with non-normally distributed residuals, Nemenyi's test can be
performed on Friedman-type ranked data.

A total of \eqn{m = k ( k -1 )/2} hypotheses can be tested.
The null hypothesis, H\eqn{_{ij}: \theta_i = \theta_j}, is tested
in the two-tailed case against the alternative,
A\eqn{_{ij}: \theta_i \ne \theta_j, ~~ i \ne j}.

The \eqn{p}-values are computed from the studentized range distribution.
}
\examples{
 ## Sachs, 1997, p. 675
 ## Six persons (block) received six different diuretics
 ## (A to F, treatment).
 ## The responses are the Na-concentration (mval)
 ## in the urine measured 2 hours after each treatment.
 ##
 y <- matrix(c(
 3.88, 5.64, 5.76, 4.25, 5.91, 4.33, 30.58, 30.14, 16.92,
 23.19, 26.74, 10.91, 25.24, 33.52, 25.45, 18.85, 20.45,
 26.67, 4.44, 7.94, 4.04, 4.4, 4.23, 4.36, 29.41, 30.72,
 32.92, 28.23, 23.35, 12, 38.87, 33.12, 39.15, 28.06, 38.23,
 26.65),nrow=6, ncol=6,
 dimnames=list(1:6, LETTERS[1:6]))
 print(y)
 friedmanTest(y)

 ## Eisinga et al. 2017
 frdAllPairsExactTest(y=y, p.adjust = "bonferroni")

 ## Conover's test
 frdAllPairsConoverTest(y=y, p.adjust = "bonferroni")

 ## Nemenyi's test
 frdAllPairsNemenyiTest(y=y)

 ## Miller et al.
 frdAllPairsMillerTest(y=y)

 ## Siegel-Castellan
 frdAllPairsSiegelTest(y=y, p.adjust = "bonferroni")

 ## Irrelevant of group order?
 x <- as.vector(y)
 g <- rep(colnames(y), each = length(x)/length(colnames(y)))
 b <- rep(rownames(y), times = length(x)/length(rownames(y)))
 xDF <- data.frame(x, g, b) # grouped by colnames

 frdAllPairsNemenyiTest(xDF$x, groups = xDF$g, blocks = xDF$b)
 o <- order(xDF$b) # order per block increasingly
 frdAllPairsNemenyiTest(xDF$x[o], groups = xDF$g[o], blocks = xDF$b[o])
 o <- order(xDF$x) # order per value increasingly
 frdAllPairsNemenyiTest(xDF$x[o], groups = xDF$g[o], blocks = xDF$b[o])

 ## formula method (only works for Nemenyi)
 frdAllPairsNemenyiTest(x ~ g | b, data = xDF)

}
\references{
Demsar, J. (2006) Statistical comparisons of classifiers over multiple
 data sets, \emph{Journal of Machine Learning Research} \bold{7}, 1--30.

Miller Jr., R. G. (1996) \emph{Simultaneous statistical inference}.
 New York: McGraw-Hill.

Nemenyi, P. (1963), \emph{Distribution-free Multiple Comparisons}.
 Ph.D. thesis, Princeton University.

Sachs, L. (1997) \emph{Angewandte Statistik}. Berlin: Springer.
}
\seealso{
\code{\link{friedmanTest}}, \code{\link{friedman.test}},
\code{\link{frdAllPairsExactTest}}, \code{\link{frdAllPairsConoverTest}},
\code{\link{frdAllPairsMillerTest}}, \code{\link{frdAllPairsSiegelTest}}
}
\concept{AllPairs}
\concept{Friedman}
\concept{Rank}
\keyword{htest}
\keyword{nonparametric}
