% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMA-package.R
\docType{package}
\name{PMA-package}
\alias{PMA-package}
\alias{PMA}
\title{Penalized Multivariate Analysis}
\description{
This package is called \strong{PMA}, for __P__enalized __M__ultivariate
__A__nalysis.  It implements three methods: A penalized matrix
decomposition, sparse principal components analysis, and sparse
canonical correlations analysis. All are described in the reference below.
The main functions are: \code{PMD}, \code{CCA} and \code{SPC}.
}
\details{
The first, \code{PMD}, performs a penalized matrix decomposition.  \code{CCA}
performs sparse canonical correlation analysis. \code{SPC} performs sparse
principal components analysis.

There also are cross-validation functions for tuning parameter selection for
each of the above methods: \code{SPC.cv}, \code{PMD.cv}, \code{CCA.permute}. And \code{PlotCGH} produces
nice plots for DNA copy number data.
}
\references{
Ali Mahzarnia, Alexander Badea (2022), Joint Estimation of Vulnerable Brain Networks and Alzheimer’s Disease Risk Via Novel Extension of Sparse Canonical Correlation at bioRxiv.
}
\keyword{package}
