% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{plot.gsPLMIX}
\alias{plot.gsPLMIX}
\title{Plot the Gibbs sampling simulations for a Bayesian mixture of Plackett-Luce models}
\usage{
\method{plot}{gsPLMIX}(x, file = "ggmcmc-output.pdf", family = NA,
  plot = NULL, param_page = 5, width = 7, height = 10,
  dev_type_html = "png", post_est = "mean", max_scale_radar = NULL,
  ...)
}
\arguments{
\item{x}{Object of class \code{gsPLMIX} returned by the \code{gibbsPLMIX} function.}

\item{file}{Character vector with the name of the file to be created in the current working directory. Defaults is "ggmcmc-output.pdf". When NULL, plots are directly returned into the current working device (not recommended). This option allows also the user to work with an opened pdf (or other) device. When the file has an html file extension, the output is an Rmarkdown report with the figures embedded in the html file.}

\item{family}{Character string indicating the name of the family of parameters to be plotted. A family of parameters is considered to be any group of parameters with the same name but different numerical values (for example \code{w[1]}, \code{w[2]}, etc). Default is \code{NA} meaning that all the parameters in the chain are plotted. Alternatively, one can choose \code{"w"}, \code{"p"}, \code{"log_lik"}, \code{"deviance"} or \code{"objective"}.}

\item{plot}{Character vector containing the names of the desired plots. Default is \code{NULL} meaning that all the plots and convergence diagnostics are built (see 'Details').}

\item{param_page}{Number of parameters to be plotted in each page. Defaults is 5.}

\item{width}{Numeric scalar indicating the width of the pdf display in inches. Defaults is 7.}

\item{height}{Numeric scalar indicating the height of the pdf display in inches. Defaults is 10.}

\item{dev_type_html}{Character vector indicating the type of graphical device for the html output. Default is \code{"png"}. Alternatively, one can choose \code{"svg"}.}

\item{post_est}{Character string indicating the point estimates of the Plackett-Luce mixture parameters to be computed from the \code{gsPLMIX} class object and then plotted in the current working device. Default is \code{"mean"}. Alternatively, one can choose \code{"median"}.}

\item{max_scale_radar}{Numeric scalar indicating the maximum value on each axis of the radar plot for the support parameter point estimates. Default is \code{NULL} meaning that the maximum of the estimated support parameters is used.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\description{
\code{plot} method for class \code{gsPLMIX}. It builds a suite of plots, visual convergence diagnostics and credible intervals for the MCMC samples of a Bayesian mixture of Plackett-Luce models. Graphics can be plotted directly into the current working device or stored into an external file placed into the current working directory.
}
\details{
Plots of the MCMC samples include histograms, densities, traceplots, running means plots, overlapped densities comparing the complete and partial samples, autocorrelation functions, crosscorrelation plots and caterpillar plots of the 90 and 95\% equal-tails credible intervals. Note that the latter are created for the support parameters (when either \code{family=NA} or \code{family="p"}), for the mixture weights in the case \eqn{G>1} (when either \code{family=NA} or \code{family="w"}), for the log-likelihood values (when \code{family="log_lik"}), for the deviance values (when \code{family="deviance"}). Convergence tools include the potential scale reduction factor and the Geweke z-score. These functionalities are implemented with a call to the \code{ggs} and \code{ggmcmc} functions of the \code{ggmcmc} package (see 'Examples' for the specification of the \code{plot} argument) and for the objective function values (when \code{family="objective"}).

By recalling the \code{chartJSRadar} function from the \code{radarchart} package and the routines of the \code{ggplot2} package, \code{plot.gsPLMIX} additionally produces a radar plot of the support parameters and, when \eqn{G>1}, a donut plot of the mixture weights based on the posterior point estimates. The radar chart is returned in the Viewer Pane.
}
\examples{

# Not run:
data(d_carconf)
GIBBS <- gibbsPLMIX(pi_inv=d_carconf, K=ncol(d_carconf), G=5, n_iter=30, n_burn=10)

# Not run:
# Plot posterior samples supplied as an gsPLMIX class object
# plot(GIBBS)

# Selected plots of the posterior samples of the support parameters
# plot(GIBBS, family="p", plot=c("compare_partial","Rhat","caterpillar"), param_page=6)

# Selected plots of the posterior samples of the mixture weights
# plot(GIBBS, family="w", plot=c("histogram","running","crosscorrelation","caterpillar"))

# Selected plots of the posterior log-likelihood values
# plot(GIBBS, family="log_lik", plot=c("autocorrelation","geweke"), param_page=1)

# Selected plots of the posterior deviance values
# plot(GIBBS, family="deviance", plot=c("traceplot","density"), param_page=1)
}
\references{
Ashton, D. and Porter, S. (2016). radarchart: Radar Chart from 'Chart.js'. R package version 0.3.1. \url{https://CRAN.R-project.org/package=radarchart}

Wickham, H. (2009). ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York.

Fernandez-i-Marin, X. (2006). ggmcmc: Analysis of MCMC Samples and Bayesian Inference, \emph{Journal of Statistical Software}, \bold{70}(9), pages 1--20, DOI: 10.18637/jss.v070.i09.
}
\seealso{
\code{\link[ggmcmc]{ggs}}, \code{\link[ggmcmc]{ggmcmc}}, \code{\link[radarchart]{chartJSRadar}} and \code{\link[ggplot2]{ggplot}}
}
\author{
Cristina Mollica and Luca Tardella
}
