% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{make_partial}
\alias{make_partial}
\title{Censoring of complete rankings/orderings}
\usage{
make_partial(data, format_input, nranked = NULL, probcens = rep(1,
  ncol(data) - 1))
}
\arguments{
\item{data}{Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of complete sequences to be censored.}

\item{format_input}{Character string indicating the format of the \code{data} input (\code{"ordering"} or \code{"ranking"}).}

\item{nranked}{Numeric vector of length \eqn{N} with the desired number of items ranked by each sample unit after censoring. If not supplied (\code{NULL}), the censoring patterns are randomly generated according to the probabilities in the \code{probcens} argument.}

\item{probcens}{Numeric vector of length \eqn{(K-1)} with the probability of each censoring pattern to be employed for the random truncation of the complete sequences (normalization is not necessary). It works only if \code{nranked} argument is \code{NULL} (see 'Details'). Default is equal probabilities.}
}
\value{
A list of two named objects:

 \item{\code{partialdata}}{ Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of partial (censored) sequences with the same format of the input \code{data} and missing positions/items denoted with zero entries.}	
 \item{\code{nranked}}{ Numeric vector of length \eqn{N} with the number of items ranked by each sample unit after censoring.}
}
\description{
Return partial top rankings/orderings from complete sequences obtained either with user-specified censoring patterns or with a random truncation.
}
\details{
The censoring of the complete sequences can be performed in: (i) a deterministic way, by specifying the number of top positions to be retained for each sample unit in the \code{nranked} argument; (ii) a random way, by sequentially specifying the probabilities of the top-1, top-2, \eqn{...}, top-\eqn{(K-1)} censoring patterns in the \code{probcens} argument. Recall that a top-\eqn{(K-1)} sequence corresponds to a complete ordering/ranking.
}
\examples{

data(d_german)
head(d_german)
d_german_cens <- make_partial(data=d_german, format_input="ordering", 
                              probcens=c(0.3, 0.3, 0.4))  
head(d_german_cens$partialdata)

## Check consistency with the nominal censoring probabilities
round(prop.table(table(d_german_cens$nranked)), 2)

}
\author{
Cristina Mollica and Luca Tardella
}
