% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate.R
\name{make_calibration_study}
\alias{make_calibration_study}
\title{Create a calibration study with calibration standards and QCs}
\usage{
make_calibration_study(
  plate,
  plate_std,
  lqc_conc = NULL,
  mqc_conc = NULL,
  hqc_conc = NULL,
  n_qc = NULL,
  qc_serial = FALSE,
  n_CS0IS0 = 1,
  n_CS0IS1 = 2,
  n_CS1IS0 = 1
)
}
\arguments{
\item{plate}{PlateObj object}

\item{plate_std}{vector of calibration standards}

\item{lqc_conc}{LQC concentration}

\item{mqc_conc}{MQC concentration}

\item{hqc_conc}{HQC concentration}

\item{n_qc}{number of QC sets}

\item{qc_serial}{logical. If TRUE, QCs are placed serially}

\item{n_CS0IS0}{number of CS0IS0 (double) blanks}

\item{n_CS0IS1}{number of CS0IS1 blanks}

\item{n_CS1IS0}{number of CS1IS0 blanks}
}
\value{
PlateObj
}
\description{
Create a calibration study with calibration standards and QCs
}
