% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkpdsim_to_nlmixr.R
\name{pkpdsim_to_nlmixr}
\alias{pkpdsim_to_nlmixr}
\title{Convert a model generated with PKPDsim to an object for nlmixr}
\usage{
pkpdsim_to_nlmixr(
  model = NULL,
  parameters = NULL,
  omega = NULL,
  res_var = NULL,
  fixed = c(),
  ini_code = NULL,
  model_code = NULL,
  model_par_code = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{model}{PKPDsim model}

\item{parameters}{list of parameters}

\item{omega}{vector describing the lower-diagonal of the between-subject variability matrix}

\item{res_var}{residual variability. Expected a list with arguments \code{prop}, \code{add}, and/or \code{exp}. NULL by default.}

\item{fixed}{vector of fixed (not estimated) parameter names}

\item{ini_code}{manually specify the \code{ini} block for nlmixr}

\item{model_code}{manually specify the \code{model} block for nlmixr}

\item{model_par_code}{manually specify the parameters section inside the \code{model} block for nlmixr}

\item{verbose}{verbose, \code{TRUE} or \code{FALSE}}

\item{...}{passed on}
}
\value{
nlmixr function
}
\description{
Convert a model generated with PKPDsim to an object for nlmixr
}
