% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddProbDup.R
\name{AddProbDup}
\alias{AddProbDup}
\title{Add probable duplicate sets fields to the PGR passport database}
\usage{
AddProbDup(pdup, db, addto = c("I", "II"), max.count = 30)
}
\arguments{
\item{pdup}{An object of class \code{ProbDup}.}

\item{db}{A data frame of the PGR passport database.}

\item{addto}{Either \code{"I"} or \code{"II"} indicating the database to 
which the data.fields are to be added (see \strong{Details}).}

\item{max.count}{The maximum count of probable duplicate sets whose 
information is to be retrieved.}
}
\value{
A data frame of the PGR passport database with the probable duplicate
  sets fields added.
}
\description{
\code{AddProbDup} adds the fuzzy, phonetic and semantic probable duplicates 
sets data fields from an object of class \code{ProbDup} to the original PGR 
passport database.
}
\details{
This function helps to add information associated with identified fuzzy, 
phonetic and semantic probable duplicate sets using the 
\code{\link[PGRdup]{ProbDup}} function to the original PGR passport database.
Associated data fields such as \code{SET_NO}, \code{ID} and \code{IDKW} are 
added based on the \code{PRIM_ID} field(column).

In case more than one KWIC index was used to generate the object of class 
\code{ProbDup}, the argument \code{addto} can be used to specify to which 
database the data fields are to be added. The default \code{"I"} indicates 
the database from which the first KWIC index was created and \code{"II"} 
indicates the database from which the second index was created.
}
\note{
When any primary ID/key records in the fuzzy, phonetic or semantic 
  duplicate sets are found to be missing from the original database 
  \code{db}, then they are ignored and only the matching records are 
  considered for adding the information with a warning.
  
  This may be due to data standardization of the primary ID/key field using 
  the function \code{\link[PGRdup]{DataClean}} before creation of the KWIC 
  index and subsequent identification of probable duplicate sets. In such a 
  case, it is recommended to use an identical data standardization operation 
  on the database \code{db} before running this function.
}
\examples{
\dontrun{

#' # Load PGR passport database
GN <- GN1000

# Specify as a vector the database fields to be used
GNfields <- c("NationalID", "CollNo", "DonorID", "OtherID1", "OtherID2")

# Clean the data
GN[GNfields] <- lapply(GN[GNfields], function(x) DataClean(x))
y1 <- list(c("Gujarat", "Dwarf"), c("Castle", "Cary"), c("Small", "Japan"),
c("Big", "Japan"), c("Mani", "Blanco"), c("Uganda", "Erect"),
c("Mota", "Company"))
y2 <- c("Dark", "Light", "Small", "Improved", "Punjab", "SAM")
y3 <- c("Local", "Bold", "Cary", "Mutant", "Runner", "Giant", "No.",
        "Bunch", "Peanut")
GN[GNfields] <- lapply(GN[GNfields], function(x) MergeKW(x, y1, delim = c("space", "dash")))
GN[GNfields] <- lapply(GN[GNfields], function(x) MergePrefix(x, y2, delim = c("space", "dash")))
GN[GNfields] <- lapply(GN[GNfields], function(x) MergeSuffix(x, y3, delim = c("space", "dash")))

# Generate KWIC index
GNKWIC <- KWIC(GN, GNfields)

# Specify the exceptions as a vector
exep <- c("A", "B", "BIG", "BOLD", "BUNCH", "C", "COMPANY", "CULTURE", 
         "DARK", "E", "EARLY", "EC", "ERECT", "EXOTIC", "FLESH", "GROUNDNUT", 
         "GUTHUKAI", "IMPROVED", "K", "KUTHUKADAL", "KUTHUKAI", "LARGE", 
         "LIGHT", "LOCAL", "OF", "OVERO", "P", "PEANUT", "PURPLE", "R", 
         "RED", "RUNNER", "S1", "SAM", "SMALL", "SPANISH", "TAN", "TYPE", 
         "U", "VALENCIA", "VIRGINIA", "WHITE")
          
# Specify the synsets as a list
syn <- list(c("CHANDRA", "AH114"), c("TG1", "VIKRAM"))

# Fetch probable duplicate sets
GNdup <- ProbDup(kwic1 = GNKWIC, method = "a", excep = exep, fuzzy = TRUE,
                 phonetic = TRUE, encoding = "primary", 
                 semantic = TRUE, syn = syn)

# Add the duplicates sets to the original database                 
GNwithdup <-  AddProbDup(pdup = GNdup, db = GN1000, addto = "I")                  

}
}
\seealso{
\code{\link[PGRdup]{DataClean}}, \code{\link[PGRdup]{KWIC}},
  \code{\link[PGRdup]{ProbDup}}
}
