% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPSEA.R
\name{runPSEA}
\alias{runPSEA}
\title{Run Protein Set Enrichment Analysis (PSEA)}
\usage{
runPSEA(
  protein,
  os.name,
  pexponent = 1,
  nperm = 1000,
  p.adj.method = "fdr",
  sig.level = 0.05,
  minSize = 1
)
}
\arguments{
\item{protein}{A dataframe with two columns. Frist column should be protein accession code, second column is the score.}

\item{os.name}{A character vector of length one with exact taxonomy name of species. If you do not know the
the exact taxonomy name of species you are working with, please read \code{\link{getTaxonomyName}}.}

\item{pexponent}{Enrichment weighting exponent, p. For values of p < 1, one can detect incoherent patterns
in a set of protein. If one expects a small number of proteins to be coherent in a large set, then p > 1 is
a good choice.}

\item{nperm}{Number of permutation to estimate false discovery rate (FDR). Default value is 1000.}

\item{p.adj.method}{The adjustment method to correct pvalues for multiple testing in enrichment.
Run p.adjust.methods() to get a list of possible methods.}

\item{sig.level}{The significance level to filter PTM (applies on adjusted p-value)}

\item{minSize}{PTMs with the number of proteins below this threshold are excluded.}
}
\value{
Returns a list of 6:
1: A dataframe with protein set enrichment analysis (PSEA) results.
Every row corresponds to a post-translational modification (PTM) pathway.
\itemize{
\item PTM: PTM keyword
\item pval: p-value for singular enrichment analysis
\item pvaladj: adjusted p-value
\item FreqinUniProt: The frequency of PTM in UniProt
\item FreqinList: The frequency of PTM in the given list
\item ES: enrichment score
\item NES: enrichmnt score normalized to mean enrichment of random samples of the same size
\item nMoreExtreme: number of times the permuted sample resulted in a profile with a larger ES value than abs(ES)
\item size: Number of proteins with the PTM
\item Enrichment: Whether the proteins in the pathway have been enriched in the list.
\item AC: Uniprot accession code (AC) of proteins with each PTM.
\item leadingEdge:
}
}
\description{
This is the main function to run protein set enrichment analysis for a list of proteins and their score.
}
\examples{
# We recommend at least nperm = 1000.
# The number of permutations was reduced to 10
# to accommodate CRAN policy on examples (run time <= 5 seconds).
psea_res <- runPSEA(protein = exmplData2, os.name = 'Rattus norvegicus (Rat)', nperm = 10)
}
