% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixparametrizations.R
\name{UpperChol}
\alias{UpperChol}
\title{Upper triangular factor of a symmetric positive definite matrix}
\usage{
UpperChol(Sigma)
}
\arguments{
\item{Sigma}{A symmetric positive definite k x k matrix that can be
passed as argument to \code{\link{chol}}.}
}
\value{
an upper triangular matrix Sigma_x, such that
Sigma = Sigma_x %*% t(Sigma_x)
}
\description{
This function is an analog to the Cholesky decomposition.
}
\examples{
# S is a symmetric positive definite matrix
M<-matrix(rexp(9),3,3); S <- M \%*\% t(M)

# This should return a zero matrix:
UpperChol(S) \%*\% t(UpperChol(S)) - S

# This should return a zero matrix too:
t(chol(S)) \%*\% chol(S) - S

# Unless S is diagonal, in the general case, this will return a
# non-zero matrix:
chol(S) \%*\% t(chol(S)) - S
}
\seealso{
\code{\link{chol}}
}
