% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_maker.R
\name{match_maker}
\alias{match_maker}
\title{Weighted matching of controls to cases using PCA results.}
\usage{
match_maker(
  PC = NULL,
  eigen_value = NULL,
  data = NULL,
  ids = NULL,
  case_control = NULL,
  num_controls = 1,
  num_PCs = 1000,
  exact_match = NULL,
  weight_dist = TRUE,
  weights = NULL
)
}
\arguments{
\item{PC}{Individual level principle components.}

\item{eigen_value}{Computed eigen value for each PC. Used to calculate the percent variance explained by each PC.}

\item{data}{Dataframe containing id and case/control status. Optionally includes covariate data for exact matching.}

\item{ids}{The unique id variable contained in both "PC" and "data."}

\item{case_control}{The case control status variable.}

\item{num_controls}{The number of controls to match to each case. Default is 1:1 matching.}

\item{num_PCs}{The total number of PCs calculated within the PCA. Default is 1000.}

\item{exact_match}{Optional variables contained in the dataframe on which to perform exact matching (i.e. sex, race, etc.).}

\item{weight_dist}{When set to true, matches are produced based on PC weighted Mahalanobis distance. Default is TRUE.}

\item{weights}{Optional user defined weights used to compute the weighted Mahalanobis distance metric.}
}
\value{
A list of matches and weights.
}
\description{
Weighted matching of controls to cases using PCA results.
}
\examples{
# Create PC data frame by subsetting provided example dataset
pcs <- as.data.frame(PCs_1000G[,c(1,5:24)])
# Create eigen values vector using example dataset
eigen_vals <- c(eigenvalues_1000G)$eigen_values
# Create Covarite data frame
cov_data <- PCs_1000G[,c(1:4)]
# Generate a case status variable using ESN 1000 Genome population
cov_data$case <- ifelse(cov_data$pop=="ESN", c(1), c(0))
# With 1 to 1 matching
 if(!requireNamespace("optmatch", quietly = TRUE)){
                        match_maker(PC = pcs,
                                    eigen_value = eigen_vals,
                                    data = cov_data,
                                    ids = c("sample"),
                                    case_control = c("case"),
                                    num_controls = 1,
                                    num_PCs = dim(cov_data)[1]
                                   )
                          }

}
