% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_risk.R
\name{DAgostino_wrapper}
\alias{DAgostino_wrapper}
\alias{risk_DAgostino}
\alias{get_risk}
\alias{DAgostino_raw}
\title{Assess risk using the method of D'Agostino et al. (2008)}
\usage{
DAgostino_wrapper(
  sex,
  age,
  total_cholesterol,
  hdl,
  systolic,
  bp_treated,
  diabetes,
  smoker,
  points = TRUE
)

risk_DAgostino(
  age,
  total_cholesterol,
  hdl,
  systolic,
  age_points,
  tc_points,
  sbp_breaks,
  sbp_points,
  diabetes,
  smoker
)

get_risk(x, breaks, values)

DAgostino_raw(result, sex)
}
\arguments{
\item{sex}{character scalar indicating either sex for one person (i.e.,
\code{male} or \code{female}), or a column name in \code{x} containing sex
values for multiple people}

\item{age}{either a numeric scalar indicating age for one person, or a
character scalar indicating the name of the column in \code{x} that
contains age information. Units are years}

\item{total_cholesterol}{same as \code{age}, but for total cholesterol, in mg/dL}

\item{hdl}{same as \code{age}, but for HDL, in mg/dL}

\item{systolic}{same as \code{age}, but for systolic blood pressure, in mmHg}

\item{bp_treated}{either a logical scalar indicating whether a person is
taking blood pressure medication, or a character scalar pointing to the
column in \code{x} that contains the same information for multiple people}

\item{diabetes}{same as \code{bp_treated}, but for the presence of diabetes}

\item{smoker}{same as\code{bp_treated}, but for smoking status}

\item{points}{logical. Return as points (default) or risk percentage?}

\item{age_points}{numeric vector giving the risk values assigned to each age
group. Used as a lookup reference for \code{x}}

\item{tc_points}{same as \code{age_points} but for total cholesterol}

\item{sbp_breaks}{numeric vector specifying which blood pressure levels to cut at}

\item{sbp_points}{same as \code{age_points} but for systolic blood pressure}

\item{x}{a value on which to lookup a risk score}

\item{breaks}{passed to \code{base::cut}}

\item{values}{numeric vector giving the risk values assigned to each interval
in \code{breaks}}

\item{result}{output from \code{risk_DAgostino}}
}
\description{
Assess risk using the method of D'Agostino et al. (2008)
}
\note{
Parameter descriptions have been inherited from \code{\link{cvd_risk}},
  but only direct scalar values (i.e., not column names) are allowed for this
  function
}
\references{
\href{https://pubmed.ncbi.nlm.nih.gov/18212285/}{D'Agostino et al. (2008)}
}
\keyword{internal}
