% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{test}
\alias{test}
\title{Hypothesis testing of the partial association coefficients}
\usage{
test(object, bootstrap_rep = 300, H0 = 0, parallel = FALSE)
}
\arguments{
\item{object}{An object of "PAsso" class, which is generated by "PAsso" function.}

\item{bootstrap_rep}{The number of bootstrap replications. It may be slow.}

\item{H0}{null hypothesis of partial correlation coefficient.}

\item{parallel}{logical argument whether conduct parallel for bootstrapping partial association.}
}
\description{
This function use bootstrapping to conduct hypothesis testing
for the partial association coefficients. It directly applies onto the "PAsso"
class of object generated by "PAsso".
}
\examples{
# Import ANES2016 data in "PAsso"
data(ANES2016)
# Parial association:
PAsso_2v <- PAsso(responses = c("PreVote.num", "PID"),
                adjustments = c("income.num", "age", "edu.year"),
                data = ANES2016)

summary(PAsso_2v, digits=4)

PAsso_2v_test <- test(object = PAsso_2v, bootstrap_rep=20, H0=0, parallel=FALSE)
PAsso_2v_test

}
