% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nopenalty.R
\name{nopenalty}
\alias{nopenalty}
\title{Classical Model-based Clustering}
\usage{
nopenalty(K, y, N = 100, kms.iter = 100, kms.nstart = 100,
           eps.diff = 1e-5, eps.em = 1e-5,
           model.crit = 'gic', short.output = FALSE)
}
\arguments{
\item{K}{A vector of the number of clusters}

\item{y}{A p-dimensional data matrix. Each row is an observation}

\item{N}{The maximum number of iterations in the EM algorithm. The default value is 100.}

\item{kms.iter}{The maximum number of iterations in the K-means algorithm whose outputs are the starting values for the EM algorithm}

\item{kms.nstart}{The number of starting values in K-means}

\item{eps.diff}{The lower bound of pairwise difference of two mean values. Any value lower than it is treated as 0}

\item{eps.em}{The lower bound for the stopping criterion.}

\item{model.crit}{The criterion used to select the number of clusters \eqn{K}. It is either `bic' for Bayesian Information Criterion or `gic' for Generalized Information Criterion.}

\item{short.output}{A short version of output is needed or not. A short version is used for computing the adaptive parameters in APFP or APL1 methods. The default value is FALSE.}
}
\value{
This function returns the esimated parameters and some statistics of the optimal model within the given \eqn{K} and \eqn{\lambda}, which is selected by BIC when \code{model.crit = 'bic'} or GIC when \code{model.crit = 'gic'}.
\item{mu.hat.best}{The estimated cluster means.}
\item{sigma.hat.best}{The estimated covariance.}
\item{p.hat.best}{The estimated cluster proportions.}
\item{s.hat.best}{The clustering assignments.}
\item{K.best}{The value of \eqn{K} that provides the optimal model}
\item{llh.best}{The log-likelihood of the optimal model}
\item{gic.best}{The GIC of the optimal model}
\item{bic.best}{The BIC of the optimal model}
\item{ct.mu.best}{The degrees of freedom in the cluster means of the optimal model}
}
\description{
This function estimates the model-based clustering which is under the framework of finite mixture models.
}
\details{
This function estimates parameters \eqn{\mu}, \eqn{\Sigma}, \eqn{\pi} and the clustering assignments in the model-based clustering using the mixture model,
\deqn{y \sim \sum_{k=1}^K \pi_k f(y|\mu_k, \Sigma)}
where \eqn{f(y|\mu_k, \Sigma_k)} is the density function of Normal distribution with mean \eqn{\mu_k} and variance \eqn{\Sigma}. Here we assume that each cluster has the same diagonal variance.

This function is also used to compute the adaptive parameters for functions \code{\link{apfp}} and \code{\link{apL1}}.
}
\examples{
y <- rbind(matrix(rnorm(100,0,1),ncol=2), matrix(rnorm(100,4,1), ncol=2))
output <- nopenalty(K = c(1:2), y)
output$mu.hat.best

}
\references{
Fraley, C., & Raftery, A. E. (2002) Model-based clustering, discriminant analysis, and density estimation. \emph{Journal of the American statistical Association} \bold{97(458)}, 611--631.
}
\seealso{
\code{\link{apfp}} \code{\link{apL1}} \code{\link{parse}}
}
\keyword{external}

