% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPgEvent.R
\name{addPgEvent}
\alias{addPgEvent}
\title{Add Pamguard Event to Database}
\usage{
addPgEvent(
  db,
  UIDs,
  binary,
  eventType,
  comment = NA,
  tableName = NULL,
  type = c("click", "dg")
)
}
\arguments{
\item{db}{database file to add an event to}

\item{UIDs}{vector of the UIDs of the individual detections to add to the event}

\item{binary}{binary file containing the detections from \code{UIDs}}

\item{eventType}{the name of the event type to add. If this is not already
present in the database, it will be added to the "Lookup" table}

\item{comment}{(optional) a comment for the event}

\item{tableName}{(optional) specify the name of the Click Detector that generated the
event table you want to add to. This only needs to be specified if you have
more than one click detector, it defaults to the first "NAME_OfflineEvents"
table in the database.}

\item{type}{type of event data to add, either \code{'click'} to add event data using
the Click Detector module, or \code{'dg'} to add event data using the Detection
Grouper module}
}
\value{
Adds to the database \code{db}, invisibly returns \code{TRUE} if successful
}
\description{
Add a new event to an existing Pamguard database in the "OfflineEvents"
  table. If the specified \code{eventType} does not exist in the database, it will
  be added to the "Lookup" table.
}
\examples{
\dontrun{
myDb <- 'PamguardDatabase.sqlite3'
myBinaries <- c('./Binaries/Bin1.pgdf', './Binaries/Bin2.pgdf')
addUIDs <- c(10000001, 10000002, 20000007, 20000008)
addPgEvent(db = myDb, UIDs = addUIDs, binary = myBinaries, eventType = 'MyNewEvent')
}
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
