% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmDuplCols.R
\name{rmDuplCols}
\alias{rmDuplCols}
\title{Remove duplicated columns from \code{data.frame}}
\usage{
rmDuplCols(x, keep_first = TRUE, ...)
}
\arguments{
\item{x}{Input \code{data.frame}.}

\item{keep_first}{A \code{logical} determining whether the first column of an 
otherwise duplicated header should be kept, defaults to \code{TRUE}.}

\item{...}{Currently not in use.}
}
\value{
Revised \code{data.frame}.
}
\description{
Automatically detect and remove columns from a \code{data.frame}
based on duplicated headers.
}
\examples{
## sample data
set.seed(123)
dat <- data.frame(matrix(rnorm(28), nc = 7))
names(dat) <- c("Col1", "Col1", "Col1", "Col2", "Col3", "Col3", "Col4")

dat
rmDuplCols(dat)
rmDuplCols(dat, keep_first = FALSE)

}
\seealso{
\code{\link{duplicated}}
}
\author{
Florian Detsch
}
