% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\docType{methods}
\name{merge}
\alias{merge}
\alias{merge,list,missing-method}
\title{Merge Objects Stored in a List}
\usage{
\S4method{merge}{list,missing}(x, by = 1L, all = TRUE, ...)
}
\arguments{
\item{x}{A \code{list} of objects of the same type (e.g. \code{Raster*} or 
\code{data.frame}).}

\item{by, all}{See \code{\link{merge.data.frame}}. Ignored if data stored 
in 'x' is not of class \code{data.frame}.}

\item{...}{Additional arguments passed to the underlying merge method (e.g. 
arguments compatible with \code{\link[raster]{merge}} and 
\code{\link[raster]{writeRaster}} for \code{Raster*} input). Ignored if data 
stored in 'x' is of class \code{data.frame}.}
}
\value{
A merged object (e.g. a new \code{Raster*} object with a larger spatial 
extent).
}
\description{
Complementing existing merge methods, e.g. \code{\link[raster]{merge}} for 
\code{Raster*} objects, which typically work with one or two inputs only, 
this function accepts a \code{list} of objects that are to be merged 
together.
}
\examples{
## Raster* input
dms = list.files(system.file("extdata", package = "Orcs")
                 , pattern = "ASTGTM2.*dem.tif$", full.names = TRUE)
dms = lapply(dms, raster)

dem = merge(dms, tolerance = 1e4)                  
plot(dem)

## data.frame input
mrg = merge(list(iris, iris, iris)
            , by = c("Species", "Sepal.Length", "Petal.Width"))
head(mrg)

}
\seealso{
\code{\link{merge.data.frame}}, \code{\link{do.call}}, 
\code{\link{Reduce}}.
}
\author{
Florian Detsch
}
