% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_rel.R
\name{make_rel}
\alias{make_rel}
\alias{make_rel.default}
\alias{make_rel.OpenSpecy}
\title{Make spectral intensities relative}
\usage{
make_rel(x, ...)

\method{make_rel}{default}(x, na.rm = FALSE, ...)

\method{make_rel}{OpenSpecy}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a numeric vector or an \R OpenSpecy object}

\item{na.rm}{logical. Should missing values be removed?}

\item{\ldots}{further arguments passed to \code{make_rel()}.}
}
\value{
\code{make_rel()} return numeric vectors (if vector provided) or an
\code{OpenSpecy} object with the normalized intensity data.
}
\description{
\code{make_rel()} converts intensities \code{x} into relative values between
0 and 1 using the standard normalization equation.
If \code{na.rm} is \code{TRUE}, missing values are removed before the
computation proceeds.
}
\details{
\code{make_rel()} is used to retain the relative height proportions between
spectra while avoiding the large numbers that can result from some spectral
instruments.
}
\examples{
make_rel(c(-1000, -1, 0, 1, 10))

}
\seealso{
\code{\link[base]{min}()} and \code{\link[base]{round}()};
\code{\link{adj_intens}()} for log transformation functions;
\code{\link{conform_spec}()} for conforming wavenumbers of an
\code{OpenSpecy} object to be matched with a reference library
}
\author{
Win Cowger, Zacharias Steinmetz
}
